package com.hero.objects.characteristics;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Dexterity extends Characteristic {
    private static String xmlID = "DEX";

    public Dexterity(Element template) {
        super(template, Dexterity.xmlID);
    }

    @Override
    public int getType() {
        return Constants.DEX;
    }

    @Override
    public String getDisplayNotes() {
        String ret = "";
        if (HeroDesigner.getActiveTemplate().is6E()) {
        	return "";
        }
        double ocv1 = 0;
        double dcv1 = 0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics()
                .size(); i++) {
            Characteristic ch = (Characteristic) HeroDesigner.getActiveHero()
                    .getCharacteristics().get(i);
            if (ch.getOcvIncreaseLevels() != 0) {
                int mul = ch.getOcvIncrease() < 0 ? -1 : 1;
                double ocv = 0;
                ocv = Math.abs(ch.getOcvIncrease())
                        * ch.getPrimaryValue() / ch.getOcvIncreaseLevels();
                ocv = ocv * mul;
                ocv1 += ocv;
            }
            if (ch.getDcvIncreaseLevels() != 0) {
                dcv1 += ch.getDcvEffect(true);
            }
        }
        double ocv2 = 0;
        double dcv2 = 0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics()
                .size(); i++) {
            Characteristic ch = (Characteristic) HeroDesigner.getActiveHero()
                    .getCharacteristics().get(i);
            if (ch.getOcvIncreaseLevels() != 0) {
                int mul = ch.getOcvIncrease() < 0 ? -1 : 1;
                double ocv = 0;
                ocv = Math.abs(ch.getOcvIncrease())
                        * ch.getSecondaryValue() / ch.getOcvIncreaseLevels();
                ocv = ocv * mul;
                ocv2 += ocv;
            }
            if (ch.getDcvIncreaseLevels() != 0) {
                dcv2 += ch.getDcvEffect(false);
            }
        }
        ret = "OCV " + Rounder.roundHalfUp(ocv1);
        if (!(ocv1 == ocv2)) {
            ret += "/" + Rounder.roundHalfUp(ocv2);
        }
        ret += " DCV " + Rounder.roundHalfUp(dcv1);
        if (!(dcv1 == dcv2)) {
            ret += "/" + Rounder.roundHalfUp(dcv2);
        }
        return ret;
    }
}